---
name: pgh-news
description: Personalized Pittsburgh local news aggregator. Interviews user about preferences (topics, neighborhoods, source types), saves settings, and delivers tailored news from 30+ local outlets. Use when asked about Pittsburgh news, local headlines, or regional journalism.
---

# Pittsburgh News Aggregator

Personalized local news from 30+ Pittsburgh sources. Learns your preferences and delivers tailored headlines.

## First-Time Setup: Interview the User

On first use (no preferences file exists), ask:

```
"I can personalize your Pittsburgh news. Quick questions:

1. TOPICS - Which interest you most? (pick any)
   □ Politics & Government  □ Crime & Courts
   □ Business & Economy     □ Sports
   □ Arts & Culture         □ Environment
   □ Education              □ Development/Real Estate
   □ Health & Science       □ Community/Human Interest

2. NEIGHBORHOODS - Any specific areas?
   □ Downtown/Strip District  □ North Side  □ South Side
   □ Oakland/Shadyside        □ East End    □ Mon Valley
   □ South Hills              □ North Hills □ Suburbs/Regional
   □ All Pittsburgh

3. SOURCE TYPES - Preference?
   □ Mainstream (Post-Gazette, TribLive, TV)
   □ Independent/Nonprofit (PublicSource, WESA)
   □ Hyperlocal (neighborhood papers)
   □ Community-specific (Courier, Jewish Chronicle)
   □ All of the above

4. Any communities to prioritize?
   □ Black Pittsburgh  □ Jewish  □ Catholic  □ Student
   □ None specifically"
```

```
5. DAILY DIGEST - Want automatic delivery?
   □ Yes, every morning (e.g., 7:00 AM)
   □ Yes, every evening (e.g., 6:00 PM)
   □ Custom time: ___
   □ No, I'll ask manually
```

Save responses to `~/.config/pgh-news/prefs.json`:
```json
{
  "topics": ["politics", "business", "environment"],
  "neighborhoods": ["east-end", "oakland"],
  "sourceTypes": ["independent", "mainstream"],
  "communities": [],
  "dailyDigest": {
    "enabled": true,
    "time": "07:00",
    "timezone": "America/New_York"
  },
  "lastUpdated": "2026-02-06"
}
```

## Setting Up Daily Digest (Cron)

If user wants automatic daily delivery, use OpenClaw's cron system:

```
cron add job:
{
  "name": "Pittsburgh News Daily Digest",
  "schedule": {
    "kind": "cron",
    "expr": "0 7 * * *",      // 7:00 AM daily (adjust based on user's choice)
    "tz": "America/New_York"
  },
  "payload": {
    "kind": "systemEvent",
    "text": "Run the pgh-news skill: fetch and deliver my personalized Pittsburgh news digest based on saved preferences in ~/.config/pgh-news/prefs.json"
  },
  "sessionTarget": "main"
}
```

**Time conversion examples:**
- 7:00 AM → `"0 7 * * *"`
- 6:00 PM → `"0 18 * * *"`
- 8:30 AM → `"30 8 * * *"`

**To modify schedule later:**
1. List jobs: `cron list`
2. Update: `cron update jobId=<id> patch={"schedule": {"expr": "0 8 * * *"}}`
3. Disable: `cron update jobId=<id> patch={"enabled": false}`
4. Remove: `cron remove jobId=<id>`

Tell user: "I've set up your daily Pittsburgh news digest for [TIME]. You'll get it automatically. Say 'change my news schedule' to adjust."

## Fetching News

Use your web fetch tool to get RSS feeds. Parse XML and extract:
- `<title>` - headline
- `<link>` - article URL
- `<pubDate>` - publication date
- `<description>` - summary (if available)

### Tier 1: Primary Sources (RSS Verified)

| Source | Feed URL | Topics |
|--------|----------|--------|
| **TribLive** | `https://triblive.com/feed/` | General, all topics |
| **PublicSource** | `https://www.publicsource.org/feed/` | Investigative, government |
| **NEXTpittsburgh** | `https://nextpittsburgh.com/feed/` | Innovation, development |
| **Allegheny Front** | `https://www.alleghenyfront.org/feed/` | Environment |
| **New Pittsburgh Courier** | `https://newpittsburghcourier.com/feed/` | Black community |
| **Pittsburgh Business Times** | `https://www.bizjournals.com/pittsburgh/feed/` | Business |
| **Pitt News** | `https://pittnews.com/feed/` | University/student |

### Tier 2: Major Sources (scrape homepage)

| Source | URL | Topics |
|--------|-----|--------|
| **90.5 WESA** | `https://www.wesa.fm/` | NPR, all topics |
| **KDKA** | `https://www.cbsnews.com/pittsburgh/` | TV, breaking news |
| **WPXI** | `https://www.wpxi.com/` | TV, local news |
| **WTAE** | `https://www.wtae.com/` | TV, local news |

### Tier 3: Hyperlocal & Niche

| Source | URL | Coverage |
|--------|-----|----------|
| **Northside Chronicle** | `https://www.thenorthsidechronicle.com/` | North Side |
| **The Bulletin** | `https://bloomfield-garfield.org/the-bulletin/` | Bloomfield/Garfield |
| **The Almanac** | `https://www.thealmanac.net/` | South suburbs |
| **Mon Valley Independent** | `https://www.monvalleyindependent.com/` | Mon Valley |
| **Pittsburgh Jewish Chronicle** | `https://jewishchronicle.timesofisrael.com/` | Jewish community |
| **Pittsburgh Manifold** | `https://www.pghindependent.com/` | Arts, culture, indie |
| **Kidsburgh** | `https://www.kidsburgh.org/` | Family, children |
| **City Cast Pittsburgh** | `https://pittsburgh.citycast.fm/` | Daily podcast/newsletter |
| **Axios Pittsburgh** | `https://www.axios.com/local/pittsburgh` | Daily briefing |

### Tier 4: Student & University

| Source | URL | Coverage |
|--------|-----|----------|
| **The Pitt News** | `https://pittnews.com/` | Pitt campus |
| **Duquesne Duke** | `https://duquesneduke.org/` | Duquesne campus |

## Filtering Logic

After fetching, filter stories based on user preferences:

1. **Topic matching**: Scan headline/description for topic keywords
   - Politics: "council", "mayor", "legislation", "vote", "election"
   - Crime: "police", "arrest", "shooting", "court", "trial"
   - Business: "company", "jobs", "development", "investment"
   - Sports: "Steelers", "Pirates", "Penguins", team names
   - Environment: "climate", "pollution", "water", "EPA"
   
2. **Neighborhood matching**: Look for place names
   - "Lawrenceville", "Shadyside", "North Side", "Strip District", etc.

3. **Source type**: Include/exclude based on prefs

4. **Recency**: Prioritize last 24-48 hours

## Output Format

Present news as a personalized digest:

```
📰 YOUR PITTSBURGH NEWS DIGEST
   Based on: Politics, Business, Environment | East End focus

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

🏛️ POLITICS & GOVERNMENT

• City Council approves new affordable housing measure
  PublicSource · 2 hours ago
  https://publicsource.org/...

• State budget negotiations stall over education funding  
  TribLive · 5 hours ago
  https://triblive.com/...

💼 BUSINESS

• Strip District development breaks ground
  NEXTpittsburgh · 3 hours ago
  https://nextpittsburgh.com/...

🌿 ENVIRONMENT

• Allegheny River cleanup initiative launches
  Allegheny Front · 1 day ago
  https://alleghenyfront.org/...

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

💡 Tip: Say "update my news preferences" to change topics.
```

## Preference Updates

If user says "change my preferences" or "update news settings":
1. Read current prefs from file
2. Show current settings
3. Ask what to change
4. Update and save

## Quick Commands

- "Pittsburgh news" → Full personalized digest
- "What's happening in [neighborhood]?" → Geo-filtered
- "Pittsburgh [topic] news" → Topic-filtered  
- "Headlines from [source]" → Single-source fetch
- "Update my news preferences" → Re-run interview
- "Set up daily news digest" → Configure cron schedule
- "Change my news schedule" → Modify delivery time
- "Stop daily news" → Disable cron job
- "Resume daily news" → Re-enable cron job

## Error Handling

- If a feed fails, skip it and note: "⚠️ [Source] unavailable"
- If no stories match filters, broaden and note: "Expanded search - no exact matches"
- If preferences file missing, run interview

## Privacy Note

Preferences are stored locally only. No data sent externally except RSS/web fetches.
